/*
 * Decompiled with CFR 0.152.
 */
package com.testautomationguru.utility;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

class ImageUtil {
    static Logger logger = Logger.getLogger(ImageUtil.class.getName());

    ImageUtil() {
    }

    static boolean compareAndHighlight(BufferedImage img1, BufferedImage img2, String fileName, boolean highlight, int colorCode) throws IOException {
        int[] p2;
        int h;
        int w = img1.getWidth();
        int[] p1 = img1.getRGB(0, 0, w, h = img1.getHeight(), null, 0, w);
        if (!Arrays.equals(p1, p2 = img2.getRGB(0, 0, w, h, null, 0, w))) {
            logger.warning("Image compared - does not match");
            if (highlight) {
                for (int i = 0; i < p1.length; ++i) {
                    if (p1[i] == p2[i]) continue;
                    p1[i] = colorCode;
                }
                BufferedImage out = new BufferedImage(w, h, 2);
                out.setRGB(0, 0, w, h, p1, 0, w);
                ImageUtil.saveImage(out, fileName);
            }
            return false;
        }
        return true;
    }

    static void saveImage(BufferedImage image, String file) {
        try {
            File outputfile = new File(file);
            ImageIO.write((RenderedImage)image, "png", outputfile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

