/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.ExitCommand;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckDirty
extends AbstractAction
implements HashTreeTraverser,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(CheckDirty.class);
    private final Map<JMeterTreeNode, TestElement> previousGuiItems = new HashMap<JMeterTreeNode, TestElement>();
    private boolean checkMode = false;
    private boolean removeMode = false;
    private boolean dirty = false;
    private static final Set<String> commands = new HashSet<String>();

    public CheckDirty() {
        ActionRouter.getInstance().addPreActionListener(ExitCommand.class, this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("exit")) {
            this.doAction(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("sub_tree_saved")) {
            this.previousGuiItems.clear();
            HashTree subTree = (HashTree)e.getSource();
            subTree.traverse((HashTreeTraverser)this);
        } else if (action.equals("sub_tree_loaded")) {
            ListedHashTree addTree = (ListedHashTree)e.getSource();
            addTree.traverse((HashTreeTraverser)this);
        } else if (action.equals("add_all")) {
            this.previousGuiItems.clear();
            GuiPackage.getInstance().getTreeModel().getTestPlan().traverse((HashTreeTraverser)this);
            if (this.isWorkbenchSaveable()) {
                GuiPackage.getInstance().getTreeModel().getWorkBench().traverse((HashTreeTraverser)this);
            }
        } else if (action.equals("check_remove") || action.equals("check_cut")) {
            GuiPackage guiPackage = GuiPackage.getInstance();
            JMeterTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
            this.removeMode = true;
            try {
                for (int i = nodes.length - 1; i >= 0; --i) {
                    guiPackage.getTreeModel().getCurrentSubTree(nodes[i]).traverse((HashTreeTraverser)this);
                }
            }
            finally {
                this.removeMode = false;
            }
        }
        if (action.equals("sub_tree_merged")) {
            this.dirty = true;
        } else {
            this.dirty = false;
            this.checkMode = true;
            try {
                HashTree wholeTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
                wholeTree.traverse((HashTreeTraverser)this);
                if (!this.dirty && this.isWorkbenchSaveable()) {
                    HashTree workbench = GuiPackage.getInstance().getTreeModel().getWorkBench();
                    workbench.traverse((HashTreeTraverser)this);
                }
            }
            finally {
                this.checkMode = false;
            }
        }
        GuiPackage.getInstance().setDirty(this.dirty);
    }

    private boolean isWorkbenchSaveable() {
        JMeterTreeNode workbenchNode = (JMeterTreeNode)((JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot()).getChildAt(1);
        return ((WorkBench)workbenchNode.getUserObject()).getSaveWorkBench();
    }

    public void addNode(Object node, HashTree subTree) {
        if (log.isDebugEnabled()) {
            log.debug("Node is class: {}", node.getClass());
        }
        JMeterTreeNode treeNode = (JMeterTreeNode)node;
        if (this.checkMode) {
            if (!this.dirty) {
                if (this.previousGuiItems.containsKey(treeNode)) {
                    if (!this.previousGuiItems.get(treeNode).equals(treeNode.getTestElement())) {
                        this.dirty = true;
                    }
                } else {
                    this.dirty = true;
                }
            }
        } else if (this.removeMode) {
            this.previousGuiItems.remove(treeNode);
        } else {
            this.previousGuiItems.put(treeNode, (TestElement)treeNode.getTestElement().clone());
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("check_dirty");
        commands.add("sub_tree_saved");
        commands.add("sub_tree_merged");
        commands.add("sub_tree_loaded");
        commands.add("add_all");
        commands.add("check_remove");
        commands.add("check_cut");
    }
}

