/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.collections.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerTableModel
extends DefaultTableModel {
    private static final Logger log = LoggerFactory.getLogger(PowerTableModel.class);
    private static final long serialVersionUID = 234L;
    private Data model = new Data();
    private Class<?>[] columnClasses;

    public PowerTableModel(String[] headers, Class<?>[] classes) {
        if (headers.length != classes.length) {
            throw new IllegalArgumentException("Header and column array sizes differ");
        }
        this.model.setHeaders(headers);
        this.columnClasses = classes;
    }

    public PowerTableModel() {
    }

    public void setRowValues(int row, Object[] values) {
        if (values.length != this.model.getHeaderCount()) {
            throw new IllegalArgumentException("Incorrect number of data items");
        }
        this.model.setCurrentPos(row);
        for (int i = 0; i < values.length; ++i) {
            this.model.addColumnValue(this.model.getHeaders()[i], values[i]);
        }
    }

    public Data getData() {
        return this.model;
    }

    public void addNewColumn(String colName, Class<?> colClass) {
        this.model.addHeader(colName);
        Class[] newClasses = new Class[this.columnClasses.length + 1];
        System.arraycopy(this.columnClasses, 0, newClasses, 0, this.columnClasses.length);
        newClasses[newClasses.length - 1] = colClass;
        this.columnClasses = newClasses;
        Object defaultValue = this.createDefaultValue(this.columnClasses.length - 1);
        this.model.setColumnData(colName, defaultValue);
        this.fireTableStructureChanged();
    }

    @Override
    public void removeRow(int row) {
        log.debug("remove row: {}", (Object)row);
        if (this.model.size() > row) {
            log.debug("Calling remove row on Data");
            this.model.removeRow(row);
        }
    }

    public void removeColumn(int col) {
        this.model.removeColumn(col);
        this.fireTableStructureChanged();
    }

    public void setColumnData(int col, List<?> data) {
        this.model.setColumnData(col, data);
    }

    public List<?> getColumnData(String colName) {
        return this.model.getColumnAsObjectArray(colName);
    }

    public void clearData() {
        String[] headers = this.model.getHeaders();
        this.model = new Data();
        this.model.setHeaders(headers);
        this.fireTableDataChanged();
    }

    @Override
    public void addRow(Object[] data) {
        if (data.length != this.model.getHeaderCount()) {
            throw new IllegalArgumentException("Incorrect number of data items");
        }
        this.model.setCurrentPos(this.model.size());
        for (int i = 0; i < data.length; ++i) {
            this.model.addColumnValue(this.model.getHeaders()[i], data[i]);
        }
    }

    @Override
    public void moveRow(int start, int end, int to) {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            rows.add(this.getRowData(i));
        }
        ArrayList subList = new ArrayList(rows.subList(start, end));
        for (int x = end - 1; x >= start; --x) {
            rows.remove(x);
        }
        rows.addAll(to, subList);
        for (int i = 0; i < rows.size(); ++i) {
            this.setRowValues(i, (Object[])rows.get(i));
        }
        super.fireTableChanged(new TableModelEvent(this));
    }

    public void addNewRow() {
        this.addRow(this.createDefaultRow());
    }

    private Object[] createDefaultRow() {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int i = 0; i < rowData.length; ++i) {
            rowData[i] = this.createDefaultValue(i);
        }
        return rowData;
    }

    public Object[] getRowData(int row) {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int i = 0; i < rowData.length; ++i) {
            rowData[i] = this.model.getColumnValue(i, row);
        }
        return rowData;
    }

    private Object createDefaultValue(int i) {
        Class<?> colClass = this.getColumnClass(i);
        try {
            return colClass.newInstance();
        }
        catch (Exception e) {
            try {
                Constructor<?> constr = colClass.getConstructor(String.class);
                return constr.newInstance("");
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr) {
                try {
                    Constructor<?> constr2 = colClass.getConstructor(Integer.TYPE);
                    return constr2.newInstance(0);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr2) {
                    try {
                        Constructor<?> constr3 = colClass.getConstructor(Long.TYPE);
                        return constr3.newInstance(0L);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr3) {
                        try {
                            Constructor<?> constr4 = colClass.getConstructor(Boolean.TYPE);
                            return constr4.newInstance(Boolean.FALSE);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr4) {
                            try {
                                Constructor<?> constr5 = colClass.getConstructor(Float.TYPE);
                                return constr5.newInstance(Float.valueOf(0.0f));
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr5) {
                                try {
                                    Constructor<?> constr6 = colClass.getConstructor(Double.TYPE);
                                    return constr6.newInstance(0.0);
                                }
                                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr6) {
                                    try {
                                        Constructor<?> constr7 = colClass.getConstructor(Character.TYPE);
                                        return constr7.newInstance(Character.valueOf(' '));
                                    }
                                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr7) {
                                        try {
                                            Constructor<?> constr8 = colClass.getConstructor(Byte.TYPE);
                                            return constr8.newInstance((byte)-128);
                                        }
                                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException constr8) {
                                            try {
                                                Constructor<?> constr9 = colClass.getConstructor(Short.TYPE);
                                                return constr9.newInstance((short)Short.MIN_VALUE);
                                            }
                                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                                                return "";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getHeaders().length;
    }

    @Override
    public String getColumnName(int column) {
        return this.model.getHeaders()[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnClasses[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.model.getColumnValue(column, row);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < this.model.size()) {
            this.model.setCurrentPos(row);
            this.model.addColumnValue(this.model.getHeaders()[column], value);
        }
    }
}

