/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.Aggregator;
import org.apache.jmeter.report.processor.AggregatorFactory;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.GraphKeysSelector;
import org.apache.jmeter.report.processor.graph.GroupData;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.SeriesData;

public abstract class AbstractGraphConsumer
extends AbstractSampleConsumer {
    protected static final String DEFAULT_GROUP = "Generic group";
    public static final String RESULT_MIN_X = "minX";
    public static final String RESULT_MAX_X = "maxX";
    public static final String RESULT_MIN_Y = "minY";
    public static final String RESULT_MAX_Y = "maxY";
    public static final String RESULT_TITLE = "title";
    public static final String RESULT_SUPPORTS_CONTROLLERS_DISCRIMINATION = "supportsControllersDiscrimination";
    public static final String RESULT_SERIES = "series";
    public static final String RESULT_SERIES_NAME = "label";
    public static final String RESULT_SERIES_DATA = "data";
    public static final String RESULT_SERIES_IS_CONTROLLER = "isController";
    public static final String RESULT_SERIES_IS_OVERALL = "isOverall";
    public static final String DEFAULT_OVERALL_SERIES_FORMAT = "Overall %s";
    public static final String DEFAULT_AGGREGATED_KEYS_SERIES_FORMAT = "%s-Aggregated";
    private final HashMap<String, GroupInfo> groupInfos;
    private final GraphKeysSelector keysSelector = this.createKeysSelector();
    private String overallSeriesFormat = "Overall %s";
    private String aggregatedKeysSeriesFormat = "%s-Aggregated";
    private boolean revertsKeysAndValues;
    private boolean renderPercentiles;
    private String title;

    protected final HashMap<String, GroupInfo> getGroupInfos() {
        return this.groupInfos;
    }

    protected final boolean revertsKeysAndValues() {
        return this.revertsKeysAndValues;
    }

    protected final void setRevertKeysAndValues(boolean revertsKeysAndValues) {
        this.revertsKeysAndValues = revertsKeysAndValues;
    }

    public final boolean rendersPercentiles() {
        return this.renderPercentiles;
    }

    public final void setRenderPercentiles(boolean renderPercentiles) {
        this.renderPercentiles = renderPercentiles;
    }

    protected final GraphKeysSelector getKeysSelector() {
        return this.keysSelector;
    }

    public final String getOverallSeriesFormat() {
        return this.overallSeriesFormat;
    }

    public final void setOverallSeriesFormat(String overallSeriesFormat) {
        this.overallSeriesFormat = overallSeriesFormat;
    }

    public final String getAggregatedKeysSeriesFormat() {
        return this.aggregatedKeysSeriesFormat;
    }

    public final void setAggregatedKeysSeriesFormat(String aggregatedKeysSeriesFormat) {
        this.aggregatedKeysSeriesFormat = aggregatedKeysSeriesFormat;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title;
    }

    protected AbstractGraphConsumer() {
        this.groupInfos = new HashMap<String, GroupInfo>(this.createGroupInfos());
    }

    protected abstract GraphKeysSelector createKeysSelector();

    protected abstract Map<String, GroupInfo> createGroupInfos();

    private void setMinResult(MapResultData result, String name, Double value) {
        ValueResultData valueResult = (ValueResultData)result.getResult(name);
        valueResult.setValue(Math.min((Double)valueResult.getValue(), value));
    }

    private void setMaxResult(MapResultData result, String name, Double value) {
        ValueResultData valueResult = (ValueResultData)result.getResult(name);
        valueResult.setValue(Math.max((Double)valueResult.getValue(), value));
    }

    private void addKeyData(MapResultData result, String group, String series, SeriesData seriesData, boolean aggregated) {
        Map<Double, Aggregator> aggInfo;
        if (aggregated) {
            series = String.format(this.aggregatedKeysSeriesFormat, series);
        }
        ListResultData seriesList = (ListResultData)result.getResult(RESULT_SERIES);
        MapResultData seriesResult = null;
        int size = seriesList.getSize();
        for (int index = 0; seriesResult == null && index < size; ++index) {
            MapResultData currSeries = (MapResultData)seriesList.get(index);
            String name = String.valueOf(((ValueResultData)currSeries.getResult(RESULT_SERIES_NAME)).getValue());
            if (!Objects.equals(name, series)) continue;
            seriesResult = currSeries;
        }
        if (seriesResult == null) {
            seriesResult = new MapResultData();
            seriesResult.setResult(RESULT_SERIES_NAME, new ValueResultData(series));
            seriesResult.setResult(RESULT_SERIES_IS_CONTROLLER, new ValueResultData(seriesData.isControllersSeries()));
            seriesResult.setResult(RESULT_SERIES_IS_OVERALL, new ValueResultData(seriesData.isOverallSeries()));
            seriesResult.setResult(RESULT_SERIES_DATA, new ListResultData());
            seriesList.addResult(seriesResult);
        }
        ListResultData dataResult = (ListResultData)seriesResult.getResult(RESULT_SERIES_DATA);
        if (aggregated) {
            aggInfo = new HashMap<Double, Aggregator>();
            aggInfo.put(seriesData.getKeysAggregator().getResult(), seriesData.getValuesAggregator());
        } else {
            aggInfo = seriesData.getAggregatorInfo();
        }
        if (!this.renderPercentiles) {
            for (Map.Entry<Double, Aggregator> entry : aggInfo.entrySet()) {
                Double key = entry.getKey();
                Double value = entry.getValue().getResult();
                ListResultData coordResult = new ListResultData();
                if (!this.revertsKeysAndValues) {
                    key = entry.getKey();
                    value = entry.getValue().getResult();
                } else {
                    key = entry.getValue().getResult();
                    value = entry.getKey();
                }
                coordResult.addResult(new ValueResultData(key));
                coordResult.addResult(new ValueResultData(value));
                dataResult.addResult(coordResult);
                this.setMinResult(result, RESULT_MIN_X, key);
                this.setMaxResult(result, RESULT_MAX_X, key);
                this.setMinResult(result, RESULT_MIN_Y, value);
                this.setMaxResult(result, RESULT_MAX_Y, value);
            }
        } else {
            long count = seriesData.getCount();
            int rank = 0;
            double percent = 0.0;
            TreeMap<Double, Aggregator> sortedInfo = new TreeMap<Double, Aggregator>(aggInfo);
            if (!this.revertsKeysAndValues) {
                for (Map.Entry<Double, Aggregator> entry : sortedInfo.entrySet()) {
                    Double value = entry.getKey();
                    percent += 100.0 * (double)entry.getValue().getCount() / (double)count;
                    double percentile = (double)rank / 10.0;
                    while (percentile < percent) {
                        ListResultData coordResult = new ListResultData();
                        coordResult.addResult(new ValueResultData(percentile));
                        coordResult.addResult(new ValueResultData(value));
                        dataResult.addResult(coordResult);
                        percentile = (double)(++rank) / 10.0;
                    }
                    this.setMinResult(result, RESULT_MIN_Y, value);
                    this.setMaxResult(result, RESULT_MAX_Y, value);
                }
                this.setMinResult(result, RESULT_MIN_X, 0.0);
                this.setMaxResult(result, RESULT_MAX_X, 100.0);
            } else {
                for (Map.Entry<Double, Aggregator> entry : sortedInfo.entrySet()) {
                    Double value = entry.getKey();
                    percent += 100.0 * (double)entry.getValue().getCount() / (double)count;
                    double percentile = (double)rank / 10.0;
                    while (percentile < percent) {
                        ListResultData coordResult = new ListResultData();
                        coordResult.addResult(new ValueResultData(value));
                        coordResult.addResult(new ValueResultData(percentile));
                        dataResult.addResult(coordResult);
                        percentile = (double)(++rank) / 10.0;
                    }
                    this.setMinResult(result, RESULT_MIN_X, value);
                    this.setMaxResult(result, RESULT_MAX_X, value);
                }
                this.setMinResult(result, RESULT_MIN_Y, 0.0);
                this.setMaxResult(result, RESULT_MAX_Y, 100.0);
            }
        }
    }

    private void aggregateValue(AggregatorFactory factory, SeriesData data, Double key, double value) {
        Aggregator valuesAgg;
        Map<Double, Aggregator> aggInfo = data.getAggregatorInfo();
        Aggregator aggregator = aggInfo.get(key);
        if (aggregator == null) {
            aggregator = factory.createValueAggregator();
            aggInfo.put(key, aggregator);
        }
        aggregator.addValue(value);
        data.incrementCount();
        Aggregator keysAgg = data.getKeysAggregator();
        if (keysAgg != null) {
            keysAgg.addValue(key);
        }
        if ((valuesAgg = data.getValuesAggregator()) != null) {
            valuesAgg.addValue(value);
        }
    }

    private MapResultData createResult() {
        boolean supportsControllersDiscrimination;
        MapResultData result = new MapResultData();
        result.setResult(RESULT_MIN_X, new ValueResultData(Double.MAX_VALUE));
        result.setResult(RESULT_MAX_X, new ValueResultData(Double.MIN_VALUE));
        result.setResult(RESULT_MIN_Y, new ValueResultData(Double.MAX_VALUE));
        result.setResult(RESULT_MAX_Y, new ValueResultData(Double.MIN_VALUE));
        result.setResult(RESULT_TITLE, new ValueResultData(this.getTitle()));
        result.setResult(RESULT_SERIES, new ListResultData());
        Iterator<GroupInfo> it = this.groupInfos.values().iterator();
        for (supportsControllersDiscrimination = true; supportsControllersDiscrimination && it.hasNext(); supportsControllersDiscrimination &= it.next().getSeriesSelector().allowsControllersDiscrimination()) {
        }
        result.setResult(RESULT_SUPPORTS_CONTROLLERS_DISCRIMINATION, new ValueResultData(supportsControllersDiscrimination));
        this.initializeExtraResults(result);
        return result;
    }

    protected abstract void initializeExtraResults(MapResultData var1);

    @Override
    public void startConsuming() {
        int channelCount = this.getConsumedChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            super.setProducedMetadata(this.getConsumedMetadata(i), i);
        }
        super.startProducing();
    }

    @Override
    public void consume(Sample sample, int channel) {
        Double key = (Double)this.keysSelector.select(sample);
        for (Map.Entry<String, GroupInfo> entryGroup : this.groupInfos.entrySet()) {
            GroupInfo groupInfo = entryGroup.getValue();
            GroupData groupData = groupInfo.getGroupData();
            AggregatorFactory factory = groupInfo.getAggregatorFactory();
            boolean overallSeries = groupInfo.enablesOverallSeries();
            boolean aggregatedKeysSeries = groupInfo.enablesAggregatedKeysSeries();
            for (String seriesName : (Iterable)groupInfo.getSeriesSelector().select(sample)) {
                Double value;
                HashMap<String, SeriesData> seriesInfo = groupData.getSeriesInfo();
                SeriesData seriesData = (SeriesData)seriesInfo.get(seriesName);
                if (seriesData == null) {
                    seriesData = new SeriesData(factory, aggregatedKeysSeries, groupInfo.getSeriesSelector().allowsControllersDiscrimination() ? sample.isController() : false, false);
                    seriesInfo.put(seriesName, seriesData);
                }
                if ((value = groupInfo.getValueSelector().select(seriesName, sample)) == null) continue;
                this.aggregateValue(factory, seriesData, key, value);
                if (!overallSeries) continue;
                SeriesData overallData = groupData.getOverallSeries();
                this.aggregateValue(factory, overallData, key, value);
            }
        }
        super.produce(sample, channel);
    }

    @Override
    public void stopConsuming() {
        super.stopProducing();
        MapResultData result = this.createResult();
        for (Map.Entry<String, GroupInfo> groupEntry : this.groupInfos.entrySet()) {
            String groupName = groupEntry.getKey();
            GroupInfo groupInfo = groupEntry.getValue();
            GroupData groupData = groupInfo.getGroupData();
            boolean overallSeries = groupInfo.enablesOverallSeries();
            boolean aggregatedKeysSeries = groupInfo.enablesAggregatedKeysSeries();
            for (Map.Entry<String, SeriesData> seriesEntry : groupData.getSeriesInfo().entrySet()) {
                String seriesName = seriesEntry.getKey();
                SeriesData seriesData = seriesEntry.getValue();
                this.addKeyData(result, groupName, seriesName, seriesData, false);
                if (!aggregatedKeysSeries) continue;
                this.addKeyData(result, groupName, seriesName, seriesData, true);
            }
            if (!overallSeries) continue;
            SeriesData overallData = groupData.getOverallSeries();
            String overallSeriesName = String.format(this.overallSeriesFormat, groupName);
            this.addKeyData(result, groupName, overallSeriesName, overallData, false);
            if (!aggregatedKeysSeries) continue;
            this.addKeyData(result, groupName, overallSeriesName, overallData, true);
        }
        this.setDataToContext(this.getName(), result);
        for (GroupInfo groupInfo : this.groupInfos.values()) {
            groupInfo.getGroupData().clear();
        }
    }
}

