/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.SumAggregatorFactory;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.report.processor.graph.AbstractGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.CountValueSelector;
import org.apache.jmeter.report.processor.graph.GraphKeysSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.util.JMeterUtils;

public class SyntheticResponseTimeDistributionGraphConsumer
extends AbstractGraphConsumer {
    private static final String FAILED_LABEL = JMeterUtils.getResString("response_time_distribution_failed_label");
    private static final MessageFormat SATISFIED_LABEL = new MessageFormat(JMeterUtils.getResString("response_time_distribution_satisfied_label"));
    private static final MessageFormat TOLERATED_LABEL = new MessageFormat(JMeterUtils.getResString("response_time_distribution_tolerated_label"));
    private static final MessageFormat UNTOLERATED_LABEL = new MessageFormat(JMeterUtils.getResString("response_time_distribution_untolerated_label"));
    private long satisfiedThreshold;
    private long toleratedThreshold;

    @Override
    protected final GraphKeysSelector createKeysSelector() {
        return new GraphKeysSelector(){

            @Override
            public Double select(Sample sample) {
                if (sample.getSuccess()) {
                    long elapsedTime = sample.getElapsedTime();
                    if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.satisfiedThreshold) {
                        return 0.0;
                    }
                    if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.toleratedThreshold) {
                        return 1.0;
                    }
                    return 2.0;
                }
                return 3.0;
            }
        };
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(1);
        SyntheticSeriesSelector syntheticSeriesSelector = new SyntheticSeriesSelector();
        groupInfos.put("Generic group", new GroupInfo(new SumAggregatorFactory(), syntheticSeriesSelector, new CountValueSelector(true), false, false));
        return groupInfos;
    }

    @Override
    protected void initializeExtraResults(MapResultData parentResult) {
        ListResultData listResultData = new ListResultData();
        String[] messages = new String[]{SATISFIED_LABEL.format(new Object[]{this.getSatisfiedThreshold()}), TOLERATED_LABEL.format(new Object[]{this.getSatisfiedThreshold(), this.getToleratedThreshold()}), UNTOLERATED_LABEL.format(new Object[]{this.getToleratedThreshold()}), FAILED_LABEL};
        for (int i = 0; i < messages.length; ++i) {
            ListResultData array = new ListResultData();
            array.addResult(new ValueResultData(i));
            array.addResult(new ValueResultData(messages[i]));
            listResultData.addResult(array);
        }
        parentResult.setResult("ticks", listResultData);
    }

    public long getSatisfiedThreshold() {
        return this.satisfiedThreshold;
    }

    public void setSatisfiedThreshold(long satisfiedThreshold) {
        this.satisfiedThreshold = satisfiedThreshold;
    }

    public long getToleratedThreshold() {
        return this.toleratedThreshold;
    }

    public void setToleratedThreshold(long toleratedThreshold) {
        this.toleratedThreshold = toleratedThreshold;
    }

    private class SyntheticSeriesSelector
    extends AbstractSeriesSelector {
        private SyntheticSeriesSelector() {
        }

        @Override
        public Iterable<String> select(Sample sample) {
            if (!sample.getSuccess()) {
                return Arrays.asList(FAILED_LABEL);
            }
            long elapsedTime = sample.getElapsedTime();
            if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.getSatisfiedThreshold()) {
                return Arrays.asList(SATISFIED_LABEL.format(new Object[]{SyntheticResponseTimeDistributionGraphConsumer.this.getSatisfiedThreshold()}));
            }
            if (elapsedTime <= SyntheticResponseTimeDistributionGraphConsumer.this.getToleratedThreshold()) {
                return Arrays.asList(TOLERATED_LABEL.format(new Object[]{SyntheticResponseTimeDistributionGraphConsumer.this.getSatisfiedThreshold(), SyntheticResponseTimeDistributionGraphConsumer.this.getToleratedThreshold()}));
            }
            return Arrays.asList(UNTOLERATED_LABEL.format(new Object[]{SyntheticResponseTimeDistributionGraphConsumer.this.getToleratedThreshold()}));
        }
    }
}

