/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomX509TrustManager
implements X509TrustManager {
    private final X509TrustManager defaultTrustManager;
    private static final Logger log = LoggerFactory.getLogger(CustomX509TrustManager.class);

    public CustomX509TrustManager(X509TrustManager defaultTrustManager) {
        if (defaultTrustManager == null) {
            throw new IllegalArgumentException("Trust manager may not be null");
        }
        this.defaultTrustManager = defaultTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (log.isDebugEnabled() && certificates != null) {
            for (int i = 0; i < certificates.length; ++i) {
                X509Certificate cert = certificates[i];
                log.debug(" Client certificate {}:\n  Subject DN: {}\n  Signature Algorithm: {}\n  Valid from: {}\n  Valid until: {}\n  Issuer: {}", new Object[]{i + 1, cert.getSubjectDN(), cert.getSigAlgName(), cert.getNotBefore(), cert.getNotAfter(), cert.getIssuerDN()});
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (log.isDebugEnabled() && certificates != null) {
            for (int i = 0; i < certificates.length; ++i) {
                X509Certificate cert = certificates[i];
                log.debug(" Server certificate {}:\n  Subject DN: {}\n  Signature Algorithm: {}\n  Valid from: {}\n  Valid until: {}\n  Issuer: {}", new Object[]{i + 1, cert.getSubjectDN(), cert.getSigAlgName(), cert.getNotBefore(), cert.getNotAfter(), cert.getIssuerDN()});
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

