/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.StringProperty;

public class RunTime
extends GenericController
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final String SECONDS = "RunTime.seconds";
    private long startTime = 0L;
    private int loopCount = 0;

    public void setRuntime(long seconds) {
        this.setProperty(new LongProperty(SECONDS, seconds));
    }

    public void setRuntime(String seconds) {
        this.setProperty(new StringProperty(SECONDS, seconds));
    }

    public long getRuntime() {
        try {
            return Long.parseLong(this.getPropertyAsString(SECONDS));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getRuntimeString() {
        return this.getPropertyAsString(SECONDS);
    }

    @Override
    public boolean isDone() {
        if (this.getRuntime() > 0L && this.getSubControllers().size() > 0) {
            return super.isDone();
        }
        return true;
    }

    private boolean endOfLoop() {
        return (System.nanoTime() - this.startTime) / 1000000000L >= this.getRuntime();
    }

    @Override
    public Sampler next() {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        if (this.endOfLoop()) {
            this.reInitialize();
            this.resetLoopCount();
            return null;
        }
        return super.next();
    }

    @Override
    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop()) {
            this.resetLoopCount();
            return null;
        }
        return this.next();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        this.loopCount = 0;
        this.startTime = 0L;
    }

    @Override
    protected int getIterCount() {
        return this.loopCount + 1;
    }

    @Override
    protected void reInitialize() {
        this.setFirst(true);
        this.resetCurrent();
        this.incrementLoopCount();
        this.recoverRunningVersion();
    }

    @Override
    public void triggerEndOfLoop() {
        super.triggerEndOfLoop();
        this.resetLoopCount();
    }
}

