/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.util.JMeterMenuBar;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookAndFeelCommand
extends AbstractAction {
    private static final Logger log;
    private static final String JMETER_LAF = "jmeter.laf";
    private static final Set<String> commands;
    private static final Preferences PREFS;
    private static final String USER_PREFS_KEY = "laf";

    public static String getJMeterLaf() {
        String laf = PREFS.get(USER_PREFS_KEY, null);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        laf = JMeterUtils.getProperty("jmeter.laf." + osName.replace(' ', '_'));
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        String[] osFamily = osName.split("\\s");
        laf = JMeterUtils.getProperty("jmeter.laf." + osFamily[0]);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        laf = JMeterUtils.getProperty(JMETER_LAF);
        if (laf != null) {
            return LookAndFeelCommand.checkLafName(laf);
        }
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    private static String checkLafName(String laf) {
        if ("System".equalsIgnoreCase(laf)) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if ("CrossPlatform".equalsIgnoreCase(laf)) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return laf;
    }

    @Override
    public void doAction(ActionEvent ev) {
        try {
            String className = ev.getActionCommand().substring("laf:".length()).replace('/', '.');
            UIManager.setLookAndFeel(className);
            JMeterUtils.refreshUI();
            PREFS.put(USER_PREFS_KEY, className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            JMeterUtils.reportErrorToUser("Look and Feel unavailable:" + e.toString());
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        UIManager.LookAndFeelInfo[] lfs;
        log = LoggerFactory.getLogger(LookAndFeelCommand.class);
        commands = new HashSet<String>();
        PREFS = Preferences.userNodeForPackage(LookAndFeelCommand.class);
        for (UIManager.LookAndFeelInfo lf : lfs = JMeterMenuBar.getAllLAFs()) {
            commands.add("laf:" + lf.getClassName());
        }
        if (log.isInfoEnabled()) {
            String jMeterLaf = LookAndFeelCommand.getJMeterLaf();
            ArrayList<String> names = new ArrayList<String>();
            for (UIManager.LookAndFeelInfo laf : lfs) {
                if (!laf.getClassName().equals(jMeterLaf)) continue;
                names.add(laf.getName());
            }
            if (!names.isEmpty()) {
                log.info("Using look and feel: {} {}", (Object)jMeterLaf, names);
            } else {
                log.info("Using look and feel: {}", (Object)jMeterLaf);
            }
        }
    }
}

