/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.processor.MaxAggregatorFactory;
import org.apache.jmeter.report.processor.MinAggregatorFactory;
import org.apache.jmeter.report.processor.PercentileAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.StaticSeriesSelector;
import org.apache.jmeter.report.processor.graph.SuccessfulElapsedTimeValueSelector;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;
import org.apache.jmeter.util.JMeterUtils;

public class ResponseTimePercentilesOverTimeGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String PERCENTILE_FORMAT = "%dth percentile";

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    private GroupInfo createPercentileGroupInfo(String propertyKey, int defaultValue, String serieName) {
        int property = JMeterUtils.getPropDefault(propertyKey, defaultValue);
        PercentileAggregatorFactory factory = new PercentileAggregatorFactory();
        factory.setPercentileIndex(property);
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName(serieName);
        return new GroupInfo(factory, seriesSelector, new SuccessfulElapsedTimeValueSelector(), false, false);
    }

    private GroupInfo createMinGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Min");
        return new GroupInfo(new MinAggregatorFactory(), seriesSelector, new SuccessfulElapsedTimeValueSelector(), false, false);
    }

    private GroupInfo createMaxGroupInfo() {
        StaticSeriesSelector seriesSelector = new StaticSeriesSelector();
        seriesSelector.setSeriesName("Max");
        return new GroupInfo(new MaxAggregatorFactory(), seriesSelector, new SuccessfulElapsedTimeValueSelector(), false, false);
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(2);
        groupInfos.put("aggregate_report_min", this.createMinGroupInfo());
        groupInfos.put("aggregate_report_max", this.createMaxGroupInfo());
        groupInfos.put("aggregate_rpt_pct1", this.createPercentileGroupInfo("aggregate_rpt_pct1", 90, String.format(PERCENTILE_FORMAT, 90)));
        groupInfos.put("aggregate_rpt_pct2", this.createPercentileGroupInfo("aggregate_rpt_pct2", 95, String.format(PERCENTILE_FORMAT, 95)));
        groupInfos.put("aggregate_rpt_pct3", this.createPercentileGroupInfo("aggregate_rpt_pct3", 99, String.format(PERCENTILE_FORMAT, 99)));
        return groupInfos;
    }
}

