/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SlowSSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSSLProtocolSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpSSLProtocolSocketFactory.class);
    private static final String PROTOCOL_LIST = JMeterUtils.getPropDefault("https.socket.protocols", "");
    private static final String[] protocols = PROTOCOL_LIST.split(" ");
    private final JsseSSLManager sslManager;
    private final int CPS;

    public HttpSSLProtocolSocketFactory(JsseSSLManager sslManager) {
        this(sslManager, 0);
    }

    public HttpSSLProtocolSocketFactory(JsseSSLManager sslManager, int cps) {
        this.sslManager = sslManager;
        this.CPS = cps;
    }

    private void setSocket(Socket socket) {
        block4: {
            if (!(socket instanceof SSLSocket)) {
                throw new IllegalArgumentException("Expected SSLSocket");
            }
            SSLSocket sock = (SSLSocket)socket;
            if (!PROTOCOL_LIST.isEmpty()) {
                try {
                    sock.setEnabledProtocols(protocols);
                }
                catch (IllegalArgumentException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Could not set protocol list: {}.", (Object)PROTOCOL_LIST);
                    log.warn("Valid protocols are: {}", (Object)this.join(sock.getSupportedProtocols()));
                }
            }
        }
    }

    private String join(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        try {
            SSLContext sslContext = this.sslManager.getContext();
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Rethrown as IOE", ex);
        }
    }

    private Socket wrapSocket(Socket sock) {
        if (this.CPS > 0) {
            return new SlowSSLSocket((SSLSocket)sock, this.CPS);
        }
        return sock;
    }

    @Override
    public Socket createSocket() throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket();
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(address, port, localAddress, localPort);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            SSLSocketFactory sslfac = this.getSSLSocketFactory();
            return sslfac.getDefaultCipherSuites();
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            SSLSocketFactory sslfac = this.getSSLSocketFactory();
            return sslfac.getSupportedCipherSuites();
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(s, host, port, autoClose);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress inetAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port, inetAddress, localPort);
        this.setSocket(sock);
        return this.wrapSocket(sock);
    }

    static {
        if (!PROTOCOL_LIST.isEmpty()) {
            log.info("Using protocol list: {}", (Object)PROTOCOL_LIST);
        }
    }
}

