/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.ScriptingTestElement;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSR223TestElement
extends ScriptingTestElement
implements Serializable,
TestStateListener {
    private static final long serialVersionUID = 232L;
    private static final Map<String, CompiledScript> compiledScriptsCache = Collections.synchronizedMap(new LRUMap(JMeterUtils.getPropDefault("jsr223.compiled_scripts_cache_size", 100)));
    private String cacheKey = "";
    private String scriptMd5 = null;

    public static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    protected ScriptEngine getScriptEngine() throws ScriptException {
        String lang = this.getScriptLanguageWithDefault();
        ScriptEngine scriptEngine = JSR223TestElement.getInstance().getEngineByName(lang);
        if (scriptEngine == null) {
            throw new ScriptException("Cannot find engine named: '" + lang + "', ensure you set language field in JSR223 Test Element: " + this.getName());
        }
        return scriptEngine;
    }

    private String getScriptLanguageWithDefault() {
        String lang = this.getScriptLanguage();
        if (StringUtils.isNotEmpty((CharSequence)lang)) {
            return lang;
        }
        return "groovy";
    }

    protected void populateBindings(Bindings bindings) {
        String label = this.getName();
        String fileName = this.getFilename();
        String scriptParameters = this.getParameters();
        Logger logger = LoggerFactory.getLogger(this.getClass());
        bindings.put("log", (Object)logger);
        bindings.put("Label", (Object)label);
        bindings.put("FileName", (Object)fileName);
        bindings.put("Parameters", (Object)scriptParameters);
        String[] args = JOrphanUtils.split((String)scriptParameters, (String)" ");
        bindings.put("args", (Object)args);
        JMeterContext jmctx = JMeterContextService.getContext();
        bindings.put("ctx", (Object)jmctx);
        JMeterVariables vars = jmctx.getVariables();
        bindings.put("vars", (Object)vars);
        Properties props = JMeterUtils.getJMeterProperties();
        bindings.put("props", (Object)props);
        bindings.put("OUT", (Object)System.out);
        Sampler sampler = jmctx.getCurrentSampler();
        bindings.put("sampler", (Object)sampler);
        SampleResult prev = jmctx.getPreviousResult();
        bindings.put("prev", (Object)prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object processFileOrScript(ScriptEngine scriptEngine, Bindings bindings) throws IOException, ScriptException {
        if (bindings == null) {
            bindings = scriptEngine.createBindings();
        }
        this.populateBindings(bindings);
        File scriptFile = new File(this.getFilename());
        boolean supportsCompilable = scriptEngine instanceof Compilable && !"bsh.engine.BshScriptEngine".equals(scriptEngine.getClass().getName());
        try {
            if (StringUtils.isEmpty((CharSequence)this.getFilename())) {
                if (StringUtils.isEmpty((CharSequence)this.getScript())) throw new ScriptException("Both script file and script text are empty for element:" + this.getName());
                if (!supportsCompilable) return scriptEngine.eval(this.getScript(), bindings);
                if (StringUtils.isEmpty((CharSequence)this.cacheKey)) return scriptEngine.eval(this.getScript(), bindings);
                this.computeScriptMD5();
                CompiledScript compiledScript = compiledScriptsCache.get(this.scriptMd5);
                if (compiledScript != null) return compiledScript.eval(bindings);
                Map<String, CompiledScript> compiledScript2 = compiledScriptsCache;
                synchronized (compiledScript2) {
                    compiledScript = compiledScriptsCache.get(this.scriptMd5);
                    if (compiledScript != null) return compiledScript.eval(bindings);
                    compiledScript = ((Compilable)((Object)scriptEngine)).compile(this.getScript());
                    compiledScriptsCache.put(this.scriptMd5, compiledScript);
                    return compiledScript.eval(bindings);
                }
            }
            if (!scriptFile.exists()) throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' does not exist or is unreadable for element:" + this.getName());
            if (!scriptFile.canRead()) throw new ScriptException("Script file '" + scriptFile.getAbsolutePath() + "' does not exist or is unreadable for element:" + this.getName());
            if (supportsCompilable) {
                String cacheKey = this.getScriptLanguage() + "#" + scriptFile.getAbsolutePath() + "#" + scriptFile.lastModified();
                CompiledScript compiledScript2 = compiledScriptsCache.get(cacheKey);
                if (compiledScript2 != null) return compiledScript2.eval(bindings);
                Map<String, CompiledScript> map = compiledScriptsCache;
                synchronized (map) {
                    compiledScript2 = compiledScriptsCache.get(cacheKey);
                    if (compiledScript2 != null) return compiledScript2.eval(bindings);
                    try (BufferedReader fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());){
                        compiledScript2 = ((Compilable)((Object)scriptEngine)).compile(fileReader);
                        compiledScriptsCache.put(cacheKey, compiledScript2);
                    }
                    return compiledScript2.eval(bindings);
                }
            }
            try (BufferedReader fileReader = new BufferedReader(new FileReader(scriptFile), (int)scriptFile.length());){
                Object object = scriptEngine.eval((Reader)fileReader, bindings);
                return object;
            }
        }
        catch (ScriptException ex) {
            Throwable rootCause = ex.getCause();
            if (!this.isStopCondition(rootCause)) throw ex;
            throw (RuntimeException)ex.getCause();
        }
    }

    private void computeScriptMD5() {
        if (this.scriptMd5 == null) {
            this.scriptMd5 = DigestUtils.md5Hex((String)this.getScript());
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public void testStarted() {
    }

    @Override
    public void testStarted(String host) {
    }

    @Override
    public void testEnded() {
        this.testEnded("");
    }

    @Override
    public void testEnded(String host) {
        compiledScriptsCache.clear();
        this.scriptMd5 = null;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String s) {
        this.scriptLanguage = s;
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }
}

