/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContextService;

class InfluxMetricCollector {
    private final StringBuilder samples;
    private final String suite;
    private final String application;

    public InfluxMetricCollector(String project, String suite) {
        this.application = project;
        this.suite = suite;
        this.samples = new StringBuilder();
    }

    public void addSample(SampleResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("samples");
        sb.append(",application=").append(this.escapeTag(this.application));
        sb.append(",suite=").append(this.escapeTag(this.suite));
        sb.append(",label=").append(this.escapeTag(result.getSampleLabel()));
        sb.append(",status=");
        if (result.isSuccessful()) {
            sb.append("Success");
        } else {
            sb.append("Failure");
        }
        sb.append(",threadname=").append(this.escapeTag(result.getThreadName()));
        sb.append(",responsecode=").append(this.escapeResponceCode(result.getResponseCode()));
        sb.append(" ").append("ath=").append(JMeterContextService.getThreadCounts().activeThreads);
        sb.append(",duration=").append(result.getTime());
        sb.append(",latency=").append(result.getLatency());
        sb.append(",bytes=").append(result.getBytesAsLong());
        sb.append(" ").append(result.getTimeStamp()).append("000000");
        sb.append("\n");
        this.samples.append(sb.toString());
    }

    public String getLineProtocol() {
        String linePropertocol = this.samples.toString();
        this.samples.setLength(0);
        return linePropertocol;
    }

    public String escapeTag(String tag) {
        tag = tag.replaceAll(",", "\\\\,").replaceAll(" ", "\\\\ ").replaceAll("=", "\\\\=").trim();
        return tag;
    }

    public String escapeResponceCode(String code) {
        if ((code = code.trim()).length() > 5) {
            code = "0";
        }
        return code;
    }
}

