/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.swing.JCheckBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.ClearGui;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.FileEditor;
import org.apache.jmeter.testbeans.gui.TextAreaEditor;
import org.apache.jmeter.util.JSR223TestElement;

public abstract class ScriptingBeanInfoSupport
extends BeanInfoSupport {
    public ScriptingBeanInfoSupport(Class<? extends TestBean> beanClass, String[] languageTags) {
        this(beanClass, languageTags, null);
    }

    protected ScriptingBeanInfoSupport(Class<? extends TestBean> beanClass, String[] languageTags, ResourceBundle rb) {
        super(beanClass);
        PropertyDescriptor p = this.property("scriptLanguage");
        p.setValue("notUndefined", Boolean.TRUE);
        if (JSR223TestElement.class.isAssignableFrom(beanClass)) {
            p.setValue("default", "groovy");
        } else {
            p.setValue("default", "");
        }
        if (rb != null) {
            p.setValue("resourceBundle", rb);
        }
        p.setValue("tags", languageTags);
        this.createPropertyGroup("scriptingLanguage", new String[]{"scriptLanguage"});
        p = this.property("parameters");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        this.createPropertyGroup("parameterGroup", new String[]{"parameters"});
        p = this.property("filename");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setPropertyEditorClass(FileEditor.class);
        this.createPropertyGroup("filenameGroup", new String[]{"filename"});
        if (JSR223TestElement.class.isAssignableFrom(beanClass)) {
            p = this.property("cacheKey");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("default", "");
            p.setPropertyEditorClass(JSR223ScriptCacheCheckboxEditor.class);
            this.createPropertyGroup("cacheKey_group", new String[]{"cacheKey"});
        }
        p = this.property("script");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setPropertyEditorClass(TextAreaEditor.class);
        this.createPropertyGroup("scripting", new String[]{"script"});
    }

    public static class JSR223ScriptCacheCheckboxEditor
    extends PropertyEditorSupport
    implements ActionListener,
    ClearGui {
        private final JCheckBox checkbox = new JCheckBox();
        private String initialValue = null;

        public JSR223ScriptCacheCheckboxEditor() {
            this.checkbox.addActionListener(this);
        }

        @Override
        public String getAsText() {
            String value = null;
            if (this.checkbox.isSelected()) {
                value = this.initialValue != null ? this.initialValue : UUID.randomUUID().toString();
            }
            return value;
        }

        @Override
        public void setAsText(String value) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.initialValue = value;
            }
            this.checkbox.setSelected(this.initialValue != null);
        }

        @Override
        public Object getValue() {
            return this.getAsText();
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException();
            }
            this.setAsText((String)value);
        }

        @Override
        public Component getCustomEditor() {
            return this.checkbox;
        }

        @Override
        public void firePropertyChange() {
            String newValue = this.getAsText();
            if (this.initialValue != null && this.initialValue.equals(newValue)) {
                return;
            }
            this.initialValue = newValue;
            super.firePropertyChange();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.firePropertyChange();
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public void clearGui() {
            this.initialValue = null;
            this.checkbox.setSelected(false);
        }
    }
}

