/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.jmeter.util.HostNameSetter;
import org.apache.jmeter.util.SlowInputStream;
import org.apache.jmeter.util.SlowOutputStream;

public class SlowSSLSocket
extends SSLSocket {
    private final int CPS;
    private final SSLSocket sslSock;

    public SlowSSLSocket(SSLSocket sock, int cps) {
        if (cps <= 0) {
            throw new IllegalArgumentException("Speed (cps) <= 0");
        }
        this.sslSock = sock;
        this.CPS = cps;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new SlowOutputStream(this.sslSock.getOutputStream(), this.CPS);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new SlowInputStream(this.sslSock.getInputStream(), this.CPS);
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.sslSock.addHandshakeCompletedListener(arg0);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslSock.getEnableSessionCreation();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslSock.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslSock.getEnabledProtocols();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslSock.getNeedClientAuth();
    }

    @Override
    public SSLSession getSession() {
        return this.sslSock.getSession();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSock.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslSock.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslSock.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslSock.getWantClientAuth();
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.sslSock.removeHandshakeCompletedListener(arg0);
    }

    @Override
    public void setEnableSessionCreation(boolean arg0) {
        this.sslSock.setEnableSessionCreation(arg0);
    }

    @Override
    public void setEnabledCipherSuites(String[] arg0) {
        this.sslSock.setEnabledCipherSuites(arg0);
    }

    @Override
    public void setEnabledProtocols(String[] arg0) {
        this.sslSock.setEnabledProtocols(arg0);
    }

    @Override
    public void setNeedClientAuth(boolean arg0) {
        this.sslSock.setNeedClientAuth(arg0);
    }

    @Override
    public void setUseClientMode(boolean arg0) {
        this.sslSock.setUseClientMode(arg0);
    }

    @Override
    public void setWantClientAuth(boolean arg0) {
        this.sslSock.setWantClientAuth(arg0);
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslSock.startHandshake();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.sslSock.bind(bindpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        this.sslSock.close();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)endpoint;
            HostNameSetter.setServerNameIndication(address.getHostString(), this.sslSock);
        }
        this.sslSock.connect(endpoint, timeout);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.sslSock.connect(endpoint);
    }

    @Override
    public SocketChannel getChannel() {
        return this.sslSock.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.sslSock.getInetAddress();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.sslSock.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.sslSock.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.sslSock.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.sslSock.getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.sslSock.getOOBInline();
    }

    @Override
    public int getPort() {
        return this.sslSock.getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.sslSock.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.sslSock.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.sslSock.getReuseAddress();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.sslSock.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.sslSock.getSoLinger();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.sslSock.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.sslSock.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.sslSock.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.sslSock.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.sslSock.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.sslSock.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.sslSock.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.sslSock.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.sslSock.sendUrgentData(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.sslSock.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.sslSock.setOOBInline(on);
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.sslSock.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.sslSock.setReuseAddress(on);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.sslSock.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.sslSock.setSoLinger(on, linger);
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.sslSock.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.sslSock.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.sslSock.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.sslSock.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.sslSock.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.sslSock.toString();
    }
}

