/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.RemoteJMeterEngine;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteJMeterEngineImpl
extends UnicastRemoteObject
implements RemoteJMeterEngine {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(RemoteJMeterEngineImpl.class);
    static final String JMETER_ENGINE_RMI_NAME = "JMeterEngine";
    private transient JMeterEngine backingEngine;
    private transient Thread ownerThread;
    private static final int DEFAULT_RMI_PORT = JMeterUtils.getPropDefault("server.rmi.port", 1099);
    private static final int DEFAULT_LOCAL_PORT = JMeterUtils.getPropDefault("server.rmi.localport", 0);
    private static final boolean CREATE_SERVER;
    private final Object LOCK = new Object();
    private final int rmiPort;
    private Properties remotelySetProperties;

    private RemoteJMeterEngineImpl(int localPort, int rmiPort) throws RemoteException {
        super(localPort);
        this.rmiPort = rmiPort;
        System.out.println("Created remote object: " + this.getRef().remoteToString());
    }

    public static void startServer(int rmiPort) throws RemoteException {
        RemoteJMeterEngineImpl engine = new RemoteJMeterEngineImpl(DEFAULT_LOCAL_PORT, rmiPort == 0 ? DEFAULT_RMI_PORT : rmiPort);
        engine.init();
    }

    private void init() throws RemoteException {
        log.info("Starting backing engine on {}", (Object)this.rmiPort);
        InetAddress localHost = null;
        String host = System.getProperties().getProperty("java.rmi.server.hostname");
        try {
            if (host == null) {
                log.info("System property 'java.rmi.server.hostname' is not defined, using localHost address");
                localHost = InetAddress.getLocalHost();
            } else {
                log.info("Resolving by name the value of System property 'java.rmi.server.hostname': {}", (Object)host);
                localHost = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException e1) {
            throw new RemoteException("Cannot start. Unable to get local host IP address.", e1);
        }
        if (log.isInfoEnabled()) {
            log.info("Local IP address={}", (Object)localHost.getHostAddress());
        }
        if (host == null && localHost.isLoopbackAddress()) {
            String hostName = localHost.getHostName();
            throw new RemoteException("Cannot start. " + hostName + " is a loopback address.");
        }
        if (localHost.isSiteLocalAddress()) {
            log.info("IP address is a site-local address; this may cause problems with remote access.\n\tCan be overridden by defining the system property 'java.rmi.server.hostname' - see jmeter-server script file");
        }
        log.debug("This = {}", (Object)this);
        Registry reg = null;
        if (CREATE_SERVER) {
            log.info("Creating RMI registry (server.rmi.create=true)");
            try {
                reg = LocateRegistry.createRegistry(this.rmiPort);
                log.debug("Created registry: {}", (Object)reg);
            }
            catch (RemoteException e) {
                String msg = "Problem creating registry: " + e;
                log.warn(msg);
                System.err.println(msg);
                System.err.println("Continuing...");
            }
        }
        try {
            if (reg == null) {
                log.debug("Locating registry");
                reg = LocateRegistry.getRegistry(this.rmiPort);
            }
            log.debug("About to rebind registry: {}", reg);
            reg.rebind(JMETER_ENGINE_RMI_NAME, this);
            log.info("Bound to registry on port {}", (Object)this.rmiPort);
        }
        catch (Exception ex) {
            log.error("rmiregistry needs to be running to start JMeter in server mode. {}", (Object)ex.toString());
            throw new RemoteException("Cannot start. See server log file.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rconfigure(HashTree testTree, String host, File jmxBase, String scriptName) throws RemoteException {
        log.info("Creating JMeter engine on host {} base '{}'", (Object)host, (Object)jmxBase);
        try {
            if (log.isInfoEnabled()) {
                log.info("Remote client host: {}", (Object)RemoteJMeterEngineImpl.getClientHost());
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            // empty catch block
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.backingEngine != null && this.backingEngine.isActive()) {
                log.warn("Engine is busy - cannot create JMeter engine");
                throw new IllegalStateException("Engine is busy - please try later");
            }
            this.ownerThread = Thread.currentThread();
            this.backingEngine = new StandardJMeterEngine(host);
            this.backingEngine.configure(testTree);
        }
        FileServer.getFileServer().setScriptName(scriptName);
        FileServer.getFileServer().setBase(jmxBase);
    }

    @Override
    public void rrunTest() throws RemoteException, JMeterEngineException, IllegalStateException {
        log.info("Running test");
        this.checkOwner("runTest");
        this.backingEngine.runTest();
    }

    @Override
    public void rreset() throws RemoteException, IllegalStateException {
        if (this.backingEngine != null) {
            log.info("Reset");
            this.checkOwner("reset");
            this.backingEngine.reset();
        } else {
            log.warn("Backing engine is null, ignoring reset");
        }
    }

    @Override
    public void rstopTest(boolean now) throws RemoteException {
        if (now) {
            log.info("Stopping test ...");
        } else {
            log.info("Shutting test ...");
        }
        this.backingEngine.stopTest(now);
        log.info("... stopped");
    }

    @Override
    public void rexit() throws RemoteException {
        log.info("Exiting");
        Thread et = new Thread(){

            @Override
            public void run() {
                log.info("Stopping the backing engine");
                RemoteJMeterEngineImpl.this.backingEngine.exit();
            }
        };
        et.setDaemon(false);
        Registry reg = LocateRegistry.getRegistry(this.rmiPort);
        try {
            reg.unbind(JMETER_ENGINE_RMI_NAME);
        }
        catch (NotBoundException e) {
            log.warn("{} is not bound", (Object)JMETER_ENGINE_RMI_NAME, (Object)e);
        }
        log.info("Unbound from registry");
        JMeterUtils.helpGC();
        et.start();
    }

    @Override
    public void rsetProperties(Properties p) throws RemoteException, IllegalStateException {
        this.checkOwner("setProperties");
        if (this.remotelySetProperties != null) {
            Properties jmeterProperties = JMeterUtils.getJMeterProperties();
            log.info("Cleaning previously set properties: {}", (Object)this.remotelySetProperties);
            for (Object key : this.remotelySetProperties.keySet()) {
                jmeterProperties.remove(key);
            }
        }
        this.backingEngine.setProperties(p);
        this.remotelySetProperties = p;
    }

    private void checkOwner(String methodName) throws IllegalStateException {
        if (this.ownerThread != null && this.ownerThread != Thread.currentThread()) {
            String msg = "The engine is not owned by this thread - cannot call " + methodName;
            log.warn(msg);
            throw new IllegalStateException(msg);
        }
    }

    static {
        if (DEFAULT_LOCAL_PORT != 0) {
            System.out.println("Using local port: " + DEFAULT_LOCAL_PORT);
        }
        CREATE_SERVER = JMeterUtils.getPropDefault("server.rmi.create", true);
    }
}

